%{
#include "VOS_API/DX_VOS_Socket.h"
#include "VOS_API/DX_VOS_File.h"
#include "VOS_API/DX_VOS_Mem.h"
%}
%apply NewHandle* { DxVosFile* newHandle};
%apply HandleForDelete* { DxVosFile* forDelete};
%apply OPAQUE_PTR { DxVosFile };
%apply (DxChar *outStr, DxUint32 inSize) { (DxChar *outStr, DxUint inSize) };

#define DX_SEEK_SET 0
#define DX_SEEK_CUR 1
#define DX_SEEK_END 2

typedef enum {
    DX_FILE_OPEN_EXISITING,
    DX_FILE_CREATE_NEW,
    DX_FILE_READ_ONLY,
    DX_FILE_WRITE_ONLY
} EDxOpenMode;

typedef enum {
    DX_NO_SHARE,
    DX_SHARE_READ,
    DX_SHARE_WRITE,
    DX_SHARE_READ_WRITE
} EDxShareMode;

DxStatus DX_VOS_FileOpen(DxVosFile* newHandle, const DxChar *aFileName, EDxOpenMode openMode, EDxShareMode shareMode);
DxStatus DX_VOS_FileOpenWithTimeStamp(DxVosFile* newHandle, const DxChar *aFileName, EDxOpenMode openMode, EDxShareMode shareMode);
DxStatus DX_VOS_FOpen(DxVosFile* newHandle, const DxChar *aFileName, const DxChar *aMode);
DxStatus DX_VOS_FClose (DxVosFile aFileHandle);
DxStatus DX_VOS_FileClose (DxVosFile* forDelete);
DxStatus DX_VOS_FReadEx(DxVosFile aFileHandle, void* outBuff, DxUint32 inSize,  DxUint32* outSize);
DxStatus DX_VOS_FWrite (DxVosFile aFileHandle, const void *inBuff, DxUint32 inSize);
DxStatus DX_VOS_FSeekEx(DxVosFile aFileHandle, DxInt32_t aOffset,DxInt aOrigin);
DxStatus DX_VOS_FTell(DxVosFile aFileHandle, DxUint32* outVal);
DxStatus DX_VOS_FGetFileSize(DxVosFile aFileHandle, DxUint32* outVal);
DxStatus DX_VOS_FEof(DxVosFile aFileHandle);
DxStatus DX_VOS_FFlush(DxVosFile aFileHandle);
DxStatus DX_VOS_FDelete(const DxChar *aFileName);
DxStatus DX_VOS_FRename(const DxChar *aOrigName, const DxChar *aNewName);
DxStatus DX_VOS_CreateDirectory(const DxChar *aDirName);
DxStatus DX_VOS_CopyFile (const DxChar *ExistingFileName, const DxChar *NewFileName, DxBool bOverwrite);
DxStatus DX_VOS_DeepDirCopy(const DxChar* source, const DxChar* dest);
DxStatus DX_VOS_DirNCat(DxChar *inOutStr, DxUint32 inSize, const DxChar *aDirName2);




DxUint32 DX_VOS_DbgPrint_EnableModulePrinting(DxUint32 ModuleCode);

DxUint32 DX_VOS_DbgPrint_DisableModulePrinting(DxUint32 ModuleCode);

const DxChar* DX_VOS_OpenLogFile(const DxChar* fileName);

void DX_VOS_CloseLogFile(void);

DxBool DX_VOS_EnableSocketLog(DxBool newValue);

DxStatus DX_VOS_MemFailAlloc(DxUint32 relativeAlloc);

typedef void (*DxMemDeallocator)(void*);

%constant void DX_VOS_DeallocMem (void * data);

DxUint32 DX_VOS_GetStackUsage();
